/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Enumeration;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.GainRatioSplitCrit;
import weka.classifiers.trees.j48.InfoGainSplitCrit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class BinC45Split
extends ClassifierSplitModel {
    private static final long serialVersionUID = -1278776919563022474L;
    private int m_attIndex;
    private int m_minNoObj;
    private boolean m_useMDLcorrection;
    private double m_splitPoint;
    private double m_infoGain;
    private double m_gainRatio;
    private double m_sumOfWeights;
    private static InfoGainSplitCrit m_infoGainCrit = new InfoGainSplitCrit();
    private static GainRatioSplitCrit m_gainRatioCrit = new GainRatioSplitCrit();

    public BinC45Split(int attIndex, int minNoObj, double sumOfWeights, boolean useMDLcorrection) {
        this.m_attIndex = attIndex;
        this.m_minNoObj = minNoObj;
        this.m_sumOfWeights = sumOfWeights;
        this.m_useMDLcorrection = useMDLcorrection;
    }

    @Override
    public void buildClassifier(Instances trainInstances) throws Exception {
        this.m_numSubsets = 0;
        this.m_splitPoint = Double.MAX_VALUE;
        this.m_infoGain = 0.0;
        this.m_gainRatio = 0.0;
        if (trainInstances.attribute(this.m_attIndex).isNominal()) {
            this.handleEnumeratedAttribute(trainInstances);
        } else {
            trainInstances.sort(trainInstances.attribute(this.m_attIndex));
            this.handleNumericAttribute(trainInstances);
        }
    }

    public final int attIndex() {
        return this.m_attIndex;
    }

    public double splitPoint() {
        return this.m_splitPoint;
    }

    public final double gainRatio() {
        return this.m_gainRatio;
    }

    @Override
    public final double classProb(int classIndex, Instance instance, int theSubset) throws Exception {
        if (theSubset <= -1) {
            double[] weights = this.weights(instance);
            if (weights == null) {
                return this.m_distribution.prob(classIndex);
            }
            double prob = 0.0;
            int i = 0;
            while (i < weights.length) {
                prob += weights[i] * this.m_distribution.prob(classIndex, i);
                ++i;
            }
            return prob;
        }
        if (Utils.gr(this.m_distribution.perBag(theSubset), 0.0)) {
            return this.m_distribution.prob(classIndex, theSubset);
        }
        return this.m_distribution.prob(classIndex);
    }

    private void handleEnumeratedAttribute(Instances trainInstances) throws Exception {
        int numAttValues = trainInstances.attribute(this.m_attIndex).numValues();
        Distribution newDistribution = new Distribution(numAttValues, trainInstances.numClasses());
        Enumeration enu = trainInstances.enumerateInstances();
        while (enu.hasMoreElements()) {
            Instance instance = (Instance)enu.nextElement();
            if (instance.isMissing(this.m_attIndex)) continue;
            newDistribution.add((int)instance.value(this.m_attIndex), instance);
        }
        this.m_distribution = newDistribution;
        int i = 0;
        while (i < numAttValues) {
            Distribution secondDistribution;
            if (Utils.grOrEq(newDistribution.perBag(i), this.m_minNoObj) && (secondDistribution = new Distribution(newDistribution, i)).check(this.m_minNoObj)) {
                this.m_numSubsets = 2;
                double currIG = m_infoGainCrit.splitCritValue(secondDistribution, this.m_sumOfWeights);
                double currGR = m_gainRatioCrit.splitCritValue(secondDistribution, this.m_sumOfWeights, currIG);
                if (i == 0 || Utils.gr(currGR, this.m_gainRatio)) {
                    this.m_gainRatio = currGR;
                    this.m_infoGain = currIG;
                    this.m_splitPoint = i;
                    this.m_distribution = secondDistribution;
                }
            }
            ++i;
        }
    }

    private void handleNumericAttribute(Instances trainInstances) throws Exception {
        int next = 1;
        int last = 0;
        int index = 0;
        int splitIndex = -1;
        this.m_distribution = new Distribution(2, trainInstances.numClasses());
        Enumeration enu = trainInstances.enumerateInstances();
        int i = 0;
        while (enu.hasMoreElements()) {
            Instance instance = (Instance)enu.nextElement();
            if (instance.isMissing(this.m_attIndex)) break;
            this.m_distribution.add(1, instance);
            ++i;
        }
        int firstMiss = i;
        double minSplit = 0.1 * this.m_distribution.total() / (double)trainInstances.numClasses();
        if (Utils.smOrEq(minSplit, this.m_minNoObj)) {
            minSplit = this.m_minNoObj;
        } else if (Utils.gr(minSplit, 25.0)) {
            minSplit = 25.0;
        }
        if (Utils.sm(firstMiss, 2.0 * minSplit)) {
            return;
        }
        double defaultEnt = m_infoGainCrit.oldEnt(this.m_distribution);
        while (next < firstMiss) {
            if (trainInstances.instance(next - 1).value(this.m_attIndex) + 1.0E-5 < trainInstances.instance(next).value(this.m_attIndex)) {
                this.m_distribution.shiftRange(1, 0, trainInstances, last, next);
                if (Utils.grOrEq(this.m_distribution.perBag(0), minSplit) && Utils.grOrEq(this.m_distribution.perBag(1), minSplit)) {
                    double currentInfoGain = m_infoGainCrit.splitCritValue(this.m_distribution, this.m_sumOfWeights, defaultEnt);
                    if (Utils.gr(currentInfoGain, this.m_infoGain)) {
                        this.m_infoGain = currentInfoGain;
                        splitIndex = next - 1;
                    }
                    ++index;
                }
                last = next;
            }
            ++next;
        }
        if (index == 0) {
            return;
        }
        if (this.m_useMDLcorrection) {
            this.m_infoGain -= Utils.log2(index) / this.m_sumOfWeights;
        }
        if (Utils.smOrEq(this.m_infoGain, 0.0)) {
            return;
        }
        this.m_numSubsets = 2;
        this.m_splitPoint = (trainInstances.instance(splitIndex + 1).value(this.m_attIndex) + trainInstances.instance(splitIndex).value(this.m_attIndex)) / 2.0;
        if (this.m_splitPoint == trainInstances.instance(splitIndex + 1).value(this.m_attIndex)) {
            this.m_splitPoint = trainInstances.instance(splitIndex).value(this.m_attIndex);
        }
        this.m_distribution = new Distribution(2, trainInstances.numClasses());
        this.m_distribution.addRange(0, trainInstances, 0, splitIndex + 1);
        this.m_distribution.addRange(1, trainInstances, splitIndex + 1, firstMiss);
        this.m_gainRatio = m_gainRatioCrit.splitCritValue(this.m_distribution, this.m_sumOfWeights, this.m_infoGain);
    }

    public final double infoGain() {
        return this.m_infoGain;
    }

    @Override
    public final String leftSide(Instances data) {
        return data.attribute(this.m_attIndex).name();
    }

    @Override
    public final String rightSide(int index, Instances data) {
        StringBuffer text = new StringBuffer();
        if (data.attribute(this.m_attIndex).isNominal()) {
            if (index == 0) {
                text.append(" = " + data.attribute(this.m_attIndex).value((int)this.m_splitPoint));
            } else {
                text.append(" != " + data.attribute(this.m_attIndex).value((int)this.m_splitPoint));
            }
        } else if (index == 0) {
            text.append(" <= " + this.m_splitPoint);
        } else {
            text.append(" > " + this.m_splitPoint);
        }
        return text.toString();
    }

    @Override
    public final String sourceExpression(int index, Instances data) {
        StringBuffer expr = null;
        if (index < 0) {
            return "i[" + this.m_attIndex + "] == null";
        }
        if (data.attribute(this.m_attIndex).isNominal()) {
            expr = index == 0 ? new StringBuffer("i[") : new StringBuffer("!i[");
            expr.append(this.m_attIndex).append("]");
            expr.append(".equals(\"").append(data.attribute(this.m_attIndex).value((int)this.m_splitPoint)).append("\")");
        } else {
            expr = new StringBuffer("((Double) i[");
            expr.append(this.m_attIndex).append("])");
            if (index == 0) {
                expr.append(".doubleValue() <= ").append(this.m_splitPoint);
            } else {
                expr.append(".doubleValue() > ").append(this.m_splitPoint);
            }
        }
        return expr.toString();
    }

    public final void setSplitPoint(Instances allInstances) {
        double newSplitPoint = -1.7976931348623157E308;
        if (!allInstances.attribute(this.m_attIndex).isNominal() && this.m_numSubsets > 1) {
            Enumeration enu = allInstances.enumerateInstances();
            while (enu.hasMoreElements()) {
                double tempValue;
                Instance instance = (Instance)enu.nextElement();
                if (instance.isMissing(this.m_attIndex) || !Utils.gr(tempValue = instance.value(this.m_attIndex), newSplitPoint) || !Utils.smOrEq(tempValue, this.m_splitPoint)) continue;
                newSplitPoint = tempValue;
            }
            this.m_splitPoint = newSplitPoint;
        }
    }

    @Override
    public void resetDistribution(Instances data) throws Exception {
        Instances insts = new Instances(data, data.numInstances());
        int i = 0;
        while (i < data.numInstances()) {
            if (this.whichSubset(data.instance(i)) > -1) {
                insts.add(data.instance(i));
            }
            ++i;
        }
        Distribution newD = new Distribution(insts, this);
        newD.addInstWithUnknown(data, this.m_attIndex);
        this.m_distribution = newD;
    }

    @Override
    public final double[] weights(Instance instance) {
        if (instance.isMissing(this.m_attIndex)) {
            double[] weights = new double[this.m_numSubsets];
            int i = 0;
            while (i < this.m_numSubsets) {
                weights[i] = this.m_distribution.perBag(i) / this.m_distribution.total();
                ++i;
            }
            return weights;
        }
        return null;
    }

    @Override
    public final int whichSubset(Instance instance) throws Exception {
        if (instance.isMissing(this.m_attIndex)) {
            return -1;
        }
        if (instance.attribute(this.m_attIndex).isNominal()) {
            if ((int)this.m_splitPoint == (int)instance.value(this.m_attIndex)) {
                return 0;
            }
            return 1;
        }
        if (Utils.smOrEq(instance.value(this.m_attIndex), this.m_splitPoint)) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

